<?php
/* --------------------------------------------------------------
 PluginsCache.php 2020-04-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Plugins\Implementation;

use Gambio\Core\Cache\CacheFactory;
use Gambio\Core\Cache\FileCache;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class PluginsCache
 * @package Gambio\Core\Application\Plugins
 */
class PluginsCache
{
    private const PLUGINS_CACHE_NAME = 'plugin_registry';
    
    /**
     *
     * @var FileCache
     */
    private $cache;
    
    
    /**
     * PluginsCache constructor.
     *
     * @param CacheFactory $cacheFactory
     *
     * @throws \Gambio\Core\Cache\Exceptions\InvalidArgumentException
     */
    public function __construct(CacheFactory $cacheFactory)
    {
        $this->cache = $cacheFactory->createCacheFor(self::PLUGINS_CACHE_NAME);
    }
    
    
    /**
     * Provides the plugins cache data.
     *
     * @return array
     */
    public function get(): array
    {
        try {
            return $this->cache->get(self::PLUGINS_CACHE_NAME, []);
        } catch (InvalidArgumentException $e) {
            return [];
        }
    }
    
    
    /**
     * Stores given data in plugins cache.
     *
     * @param array $pluginsCache
     */
    public function set(array $pluginsCache): void
    {
        try {
            $this->cache->set(self::PLUGINS_CACHE_NAME, $pluginsCache);
        } catch (InvalidArgumentException $e) {
        }
    }
    
    
    /**
     * Verification method to check if the plugins cache exists.
     *
     * @return bool
     */
    public function has(): bool
    {
        try {
            return $this->cache->has(self::PLUGINS_CACHE_NAME);
        } catch (InvalidArgumentException $e) {
            return false;
        }
    }
    
    
    /**
     * Deletes the plugins cache data.
     */
    public function delete(): void
    {
        try {
            $this->cache->delete(self::PLUGINS_CACHE_NAME);
        } catch (InvalidArgumentException $e) {
        }
    }
}